package src;

import java.util.Vector;

/**
 * OctreeCoordinateItem class
 * 
 * Represents an item in an octree structure with a spatial coordinate,
 * an index, a type, and associated elements. This class implements the
 * OctreeDataItem interface and provides methods for retrieving and 
 * managing its data.
 * 
 * <P>
 * @author      Apostol Gramada
 */
public class OctreeCoordinateItem implements OctreeDataItem
{
    double[] coord;
    int ind;
    int type = -1;
    Vector<Object> elements = null;

    public OctreeCoordinateItem(double[] coord, int ind)
    {
        this.coord = coord;
        this.ind = ind;
    }

    public OctreeCoordinateItem(double[] coord, int ind, int type)
    {
        this.coord = coord;
        this.ind = ind;
        this.type = type;
    }

    public void setElements(Vector<Object> elmts)
    {
        this.elements = elmts;
    }

    @Override
    public double[] getCoordinate()
    {
        // TODO Auto-generated method stub
        return coord;
    }

    @Override
    public int getIndex()
    {
        // TODO Auto-generated method stub
        return ind;
    }

    public int getType()
    {
        return type;
    }

    public Vector<Object> getElements()
    {
        return elements;
    }
}
