## Overview

This project aims to develop a computational tool for coarse-graining biological molecules, including data parsing, partitioning algorithms, and integration with Octree structures. Designed and implemented methods for generating coarse-grained models, ensuring efficient simulations and reliable data outputs.

This project implements a Java application with multiple classes, including:

- `CGPartitioning`
- `Octree`
- `OctreeCoordinateItem`
- `OctreeDataItem`
- `PointWithCharge`

The project uses a `Makefile` to simplify the process of compiling, running, and cleaning.

## Requirements

- **Java Development Kit (JDK)**
- **`make` Utility**
- **`git`** (Version Control for development purposes)

## Usage

From the root directory, you can manually compile and run the project using purely Java.

Create a build directory and compile the Java classes:
```bash
mkdir -p build
javac -d build src/*.java
```

Run the main project with your 2 input files and 1 output file as arguments (the arguments for input and output files should be in that order: point with charge first, control points file second, and output file name last):
```bash
java -cp build src.CGPartitioning pointsWithChargeFile.txt controlPointsFile.txt irrParts_Output.txt
```

Alternatively, the provided `Makefile` automates common tasks. Below are the available commands:

### Available Commands

- **`make ARGS='points_with_charge_file control_point_file'`**  
  This command runs the application.
  
  **Example**:  
  ```bash
  make ARGS='pointsWithCharge1MYK.txt controlPoints1MYK.txt irrParts_Output.txt'
  ```

- **`make compile`**  
  Compile all Java files.

- **`make run ARGS='points_with_charge_file control_point_file output_file'`**  
  Run the Java project from `/build/src/CGPartitioning` with argument files.
  
  **Example**:  
  ```bash
  make run ARGS='pointsWithCharge1MYK.txt controlPoints1MYK.txt irrParts_Output.txt'
  ```

- **`make clean`**  
  Remove directory `/build` with all compiled files.

- **`make help`**  
  Show help message with all available make commands for this project.

## Files Formatting

### Input Files Format

The project required two input text files with specific formats. These two files must be provided as command-line arguments. The first file to provide is the **Point Charge File**, while the second is the **Control Point File**.

1. **Point Charge File**

    Contains coordinates paired with charge values. Each entry is enclosed in double curly braces (`{{}}`), where the first part represents the coordinates (`X, Y, Z`), and the second part specifies the charge. Each set of coordinates paired with charge values is separated by a newline.

    **Example Format**:
    ```txt
    {{X1, Y1, Z1}, Charge1}
    {{X2, Y2, Z2}, Charge2}
    {{X3, Y3, Z3}, Charge3}
    ...
    ```

    **Simple**:
    ```txt
    {{39.266, 59.555, 46.185}, -0.3}
    {{38.125, 60.364, 46.626}, 0.21}
    {{36.859, 59.512, 46.734}, 0.51}
    {{36.625, 58.613, 45.922}, -0.51}
    ```

2. **Control Point File**

    Contains a list of coordinates, each enclosed in curly braces (`{}`). Each coordinate is represented by three floating-point numbers (`X, Y, Z`). Each set of coordinates is separated by a newline.

    **Example Format**:
    ```txt
    {X1, Y1, Z1}
    {X2, Y2, Z2}
    {X3, Y3, Z3}
    ...
    ```

    **Simple**:
    ```txt
    {9.455, 47.808, 48.53}
    {10.554, 47.771, 47.575}
    {9.704, 47.365, 48.096}
    ```

### Output File Format

Your data will be stored in a text file that you’ll provide as a third argument in your command-line. The generic format is an array of a 2D array of 3 floating point coordinates, each paired with charge value. The last two indices of the outer array represent the control points for the second-to-last element, and the Euclidean distance is the final element of the array. Each new line represents a new set of data that contains the previously described structure.

Here’s an example of what your output might look like:
```txt
{{{{X1, Y1, Z1}, Charge1}, {{X2, Y2, Z2}, Charge2}, {{X3, Y3, Z3}, Charge3}, {{XN, YN, ZN}, ChargeN}}, index1, distance1}
{{{{X1, Y1, Z1}, Charge1}}, index2, distance2}
{{{{X1, Y1, Z1}, Charge1}, {{XN, YN, ZN}, ChargeN}}, index3, distance3}
```